function [U,I,t] = read_data_keithley(folder,fig_on)
% script for importing data from Keithley

%clear all, close all
%folder = 'D:\Dropbox\Desalination\Figures for the manuscript\Data for IV-plots\chip13_0.01mMNaCl_3uLmin_4';
D = dir([folder '\*.txt']);
files = D;
num = length(D(not([D.isdir])));

U = [];
I = [];
T = [];
for k = 1:num
    % file_in = [folder '\' sprintf('%03d',(k-1)) 'v_up_ts.txt'];
    % files{k} = file_in;
    file_in = [folder '\' files(k, 1).name];
    [U_in,I_in,~,Y_in,MO_in,D_in,H_in,M_in,S_in,~] = import_Keithley_HaaseAS(file_in);
    U = [U; U_in];
    I = [I; I_in];
    T = [T; datenum(Y_in,MO_in,D_in,H_in,M_in,S_in)];
end

for k = 1:length(T)
    t(k) = etime(datevec(T(k)),datevec(T(1)));
end

% plot figures
if fig_on == 1
    
    nn = 0;
    
    nn = nn+1;
    figure(nn)
    plot(U,1e6.*I,'k.-')
    xlabel('U [V]')
    ylabel('I [\muA]')
    xlim([0 ceil(max(U))])
    
    nn = nn+1;
    figure(nn)
    plot(t,1e6.*I,'k.-')
    xlabel('t [s]')
    ylabel('I [\muA]')
    
    nn = nn+1;
    figure(nn)
    plot(t,U,'k.-')
    xlabel('t [s]')
    ylabel('U [V]')
    
else
end
end
